/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.common.entity.Dog;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public class DogGreedyFireSafeSearchPath
extends Path {
    private ArrayList<Node> nodes;
    private Dog dog;
    public boolean finished;
    private int maxLength;
    private Node startNode;
    private int walkableCount = 0;

    private DogGreedyFireSafeSearchPath(Dog dog, ArrayList<Node> nodes, int maxLength) {
        super(nodes, dog.m_20183_(), false);
        this.nodes = nodes;
        this.dog = dog;
        this.maxLength = maxLength;
    }

    public static DogGreedyFireSafeSearchPath create(Dog dog, int maxLength) {
        Optional<Node> start_node = DogGreedyFireSafeSearchPath.getStartNode(dog);
        if (!start_node.isPresent()) {
            return null;
        }
        ArrayList<Node> initNodes = new ArrayList<Node>(maxLength);
        initNodes.add(start_node.get());
        DogGreedyFireSafeSearchPath ret = new DogGreedyFireSafeSearchPath(dog, initNodes, maxLength);
        ret.startNode = start_node.get();
        Optional<Node> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(ret);
        if (!node_optional.isPresent()) {
            return null;
        }
        initNodes.clear();
        initNodes.add(node_optional.get());
        return ret;
    }

    private static Optional<Node> getStartNode(Dog dog) {
        BlockPos dog_b0 = dog.m_20183_();
        if (DogGreedyFireSafeSearchPath.isValidStart(dog, dog_b0)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(dog_b0);
        }
        AABB dog_bb = dog.m_20191_();
        int min_x = Mth.m_14107_((double)dog_bb.f_82288_);
        int min_z = Mth.m_14107_((double)dog_bb.f_82290_);
        int max_x = Mth.m_14107_((double)dog_bb.f_82291_);
        int max_z = Mth.m_14107_((double)dog_bb.f_82293_);
        for (int i = min_x; i <= max_x; ++i) {
            for (int j = min_z; j <= max_z; ++j) {
                BlockPos check_b0 = new BlockPos(i, dog_b0.m_123342_(), j);
                if (!DogGreedyFireSafeSearchPath.isValidStart(dog, check_b0)) continue;
                return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(check_b0);
            }
        }
        return Optional.empty();
    }

    private static boolean isValidStart(Dog dog, BlockPos pos) {
        BlockPos pos_below = pos.m_7495_();
        BlockState state_under = dog.m_9236_().m_8055_(pos_below);
        return state_under.m_60838_((BlockGetter)dog.m_9236_(), pos_below);
    }

    private static Optional<Node> blockPosToNodeOptional(BlockPos pos) {
        return Optional.of(new Node(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
    }

    public void m_77374_() {
        super.m_77374_();
        if (this.finished) {
            return;
        }
        boolean append_result = this.tryAppendPath();
        if (!append_result) {
            this.finished = true;
        }
    }

    public int getWalkableCount() {
        return this.walkableCount;
    }

    public boolean m_77392_() {
        if (this.finished) {
            return true;
        }
        return this.m_77399_() >= this.nodes.size();
    }

    public boolean tryAppendPath() {
        if (this.m_77399_() >= this.maxLength) {
            return false;
        }
        Optional<Node> node_optional = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(this);
        if (node_optional.isPresent()) {
            return false;
        }
        Node node = node_optional.get();
        if (node.f_77282_ != BlockPathTypes.WALKABLE && this.walkableCount > 0) {
            return false;
        }
        this.nodes.add(node);
        if (node.f_77282_ == BlockPathTypes.WALKABLE) {
            ++this.walkableCount;
        }
        return true;
    }

    private boolean containNode(BlockPos node0) {
        for (Node node : this.nodes) {
            if (!node.equals((Object)new Node(node0.m_123341_(), node0.m_123342_(), node0.m_123343_()))) continue;
            return true;
        }
        return false;
    }

    private static Optional<Node> scanSurroundingForNextPos(DogGreedyFireSafeSearchPath path) {
        float malus;
        boolean is_last_resort;
        int j;
        int i;
        if (path.nodes.isEmpty()) {
            return Optional.empty();
        }
        BlockPos b0 = path.nodes.get(path.nodes.size() - 1).m_77288_();
        float malus_min = Float.MAX_VALUE;
        Node node_chosen = null;
        boolean[] BLOCKED_0_Z = new boolean[2];
        boolean[] BLOCKED_X_0 = new boolean[2];
        BlockPathTypes pathtype_above = WalkNodeEvaluator.m_77604_((BlockGetter)path.dog.m_9236_(), (BlockPos.MutableBlockPos)b0.m_7494_().m_122032_());
        Node last_resort = null;
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean clear_walkable;
                boolean is_blocked;
                Node node;
                if (i == 0 && j == 0 || i * j != 0 || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.m_7918_(i, 0, j))) == null) continue;
                boolean bl = is_blocked = node.f_77282_ == BlockPathTypes.BLOCKED || node.f_77272_ > b0.m_123342_() && pathtype_above == BlockPathTypes.BLOCKED;
                if (is_blocked) {
                    if (i != 0) {
                        BLOCKED_X_0[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    BLOCKED_0_Z[j > 0 ? 1 : 0] = true;
                    continue;
                }
                boolean bl2 = clear_walkable = node.f_77282_ == BlockPathTypes.WALKABLE && pathtype_above == BlockPathTypes.OPEN;
                if (clear_walkable) {
                    return Optional.of(node);
                }
                boolean bl3 = is_last_resort = node.f_77272_ > b0.m_123342_() && pathtype_above != BlockPathTypes.BLOCKED;
                if (is_last_resort) {
                    last_resort = node;
                    if (i != 0) {
                        BLOCKED_X_0[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    BLOCKED_0_Z[j > 0 ? 1 : 0] = true;
                    continue;
                }
                malus = path.dog.m_21439_(node.f_77282_);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                boolean is_clearly_walkable;
                Node node;
                boolean diagonal_blocked;
                if (i == 0 && j == 0 || i * j == 0) continue;
                boolean bl = BLOCKED_0_Z[j > 0 ? 1 : 0] && BLOCKED_X_0[i > 0 ? 1 : 0] ? true : (diagonal_blocked = false);
                if (diagonal_blocked || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.m_7918_(i, 0, j))) == null || node.f_77282_ == BlockPathTypes.BLOCKED) continue;
                boolean bl4 = is_clearly_walkable = node.f_77282_ == BlockPathTypes.WALKABLE && pathtype_above == BlockPathTypes.OPEN;
                if (is_clearly_walkable) {
                    return Optional.of(node);
                }
                boolean bl5 = is_last_resort = node.f_77272_ > b0.m_123342_() && pathtype_above != BlockPathTypes.BLOCKED;
                if (is_last_resort) {
                    last_resort = node;
                    continue;
                }
                malus = path.dog.m_21439_(node.f_77282_);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        if (node_chosen != null) {
            return Optional.of(node_chosen);
        }
        if (last_resort != null) {
            return Optional.of(last_resort);
        }
        return Optional.empty();
    }

    private static Node checkPos(DogGreedyFireSafeSearchPath path, BlockPos pos) {
        BlockPos.MutableBlockPos b1 = pos.m_122032_();
        BlockPathTypes b1_type = WalkNodeEvaluator.m_77604_((BlockGetter)path.dog.m_9236_(), (BlockPos.MutableBlockPos)b1.m_122032_());
        int offsetY = 0;
        if (b1_type == BlockPathTypes.BLOCKED) {
            offsetY = 1;
        } else if (b1_type == BlockPathTypes.OPEN) {
            offsetY = -1;
        }
        if (offsetY != 0) {
            b1.m_122184_(0, offsetY, 0);
            b1_type = WalkNodeEvaluator.m_77604_((BlockGetter)path.dog.m_9236_(), (BlockPos.MutableBlockPos)b1.m_122032_());
        }
        if (b1_type == BlockPathTypes.BLOCKED) {
            Node ret_node = new Node(b1.m_123341_(), b1.m_123342_(), b1.m_123343_());
            ret_node.f_77282_ = b1_type;
            return ret_node;
        }
        if (path.containNode((BlockPos)b1)) {
            return null;
        }
        if (path.startNode.m_77288_().equals((Object)b1)) {
            return null;
        }
        if (b1_type == BlockPathTypes.WALKABLE) {
            Node ret_node = new Node(b1.m_123341_(), b1.m_123342_(), b1.m_123343_());
            ret_node.f_77282_ = b1_type;
            return ret_node;
        }
        if (b1_type == BlockPathTypes.OPEN) {
            return null;
        }
        float malus = path.dog.m_21439_(b1_type);
        if (malus < 0.0f) {
            return null;
        }
        Node ret_node = new Node(b1.m_123341_(), b1.m_123342_(), b1.m_123343_());
        ret_node.f_77282_ = b1_type;
        return ret_node;
    }
}

